// src/components/BookingForm.js
import React, { useState } from 'react';

const BookingForm = ({ room, onSubmit, onClose }) => {
  const [formData, setFormData] = useState({
    name: '',
    email: '',
    checkIn: '',
    checkOut: '',
    guests: 1
  });

  const handleSubmit = (e) => {
    e.preventDefault();
    onSubmit(formData);
  };

  return (
    <div className="booking-modal">
      <div className="booking-form">
        <h2>Book Room</h2>
        <input
          type="text"
          placeholder="Full Name"
          value={formData.name}
          onChange={e => setFormData({...formData, name: e.target.value})}
        />
        <input
          type="email"
          placeholder="Email"
          value={formData.email}
          onChange={e => setFormData({...formData, email: e.target.value})}
        />
        <div className="date-inputs">
          <input
            type="date"
            value={formData.checkIn}
            onChange={e => setFormData({...formData, checkIn: e.target.value})}
          />
          <input
            type="date"
            value={formData.checkOut}
            onChange={e => setFormData({...formData, checkOut: e.target.value})}
          />
        </div>
        <input 
          type="number"
          min="1"
          max={room?.capacity || 4}
          value={formData.guests}
          onChange={e => setFormData({...formData, guests: parseInt(e.target.value)})}
        />
        <button onClick={handleSubmit}>Confirm Booking</button>
        <button className="cancel" onClick={onClose}>Cancel</button>
      </div>
    </div>
  );
};

export default BookingForm;