// src/components/RoomCard.js
import React from 'react';
import { FaWifi, FaTv, FaSnowflake, FaWineGlass, FaHotTub } from 'react-icons/fa';

const RoomCard = ({ room, onBookRoom }) => {
  const getAmenityIcon = (amenity) => {
    switch(amenity) {
      case 'WiFi': return <FaWifi />;
      case 'TV': return <FaTv />;
      case 'AC': return <FaSnowflake />;
      case 'Mini Bar': return <FaWineGlass />;
      case 'Jacuzzi': return <FaHotTub />;
      default: return null;
    }
  };

  return (
    <div className="room-card">
      <img 
        src={room.image} 
        alt={`${room.type} Room`} 
        className="room-image"
        style={{ height: '150px', objectFit: 'cover' }} // Reduced height
      />
      <div className="room-info">
        <h3>{room.type} Room</h3>
        <p className="price">${room.price}/night</p>
        <div className="amenities">
          {room.amenities.map(amenity => (
            <span key={amenity} className="amenity-icon" title={amenity}>
              {getAmenityIcon(amenity)}
            </span>
          ))}
        </div>
        <button onClick={() => onBookRoom(room)}>Book Now</button>
      </div>
    </div>
  );
};

export default RoomCard;