
  
  // src/components/RoomList.js
  import React from 'react';
  import { getRooms } from '../utils/dataManager';
  
  const RoomList = ({ onBookRoom }) => {
    const rooms = getRooms();
  
    return (
      <div className="room-list">
        {rooms.map(room => (
          <div key={room.id} className="room-card">
            <h3>{room.type} Room</h3>
            <p className="price">Price: ${room.price}/night</p>
            <p>Capacity: {room.capacity} persons</p>
            <div className="amenity-list">
              {room.amenities.map(amenity => (
                <span key={amenity} className="amenity-tag">{amenity}</span>
              ))}
            </div>
            <button onClick={() => onBookRoom(room.id)}>Book Now</button>
          </div>
        ))}
      </div>
    );
  };
  
  export default RoomList;