const express = require('express');
const path = require('path');

const app = express();
const PORT = process.env.PORT || 5000;

// Serve static files from the React build directory
app.use(express.static(path.join(__dirname, 'build')));

// Parse JSON payloads
app.use(express.json());

// Serve React app for all routes
app.get('*', (req, res) => {
  res.sendFile(path.join(__dirname, 'build', 'index.html'));
});

app.listen(PORT, () => {
  console.log(`Mewar Result System running on port ${PORT}`);
});