import React from 'react';
import ResultForm from './ResultForm';
import ResultTable from './ResultTable';

const AdminDashboard = ({ results, onSubmit, onDelete, onLogout }) => {
  return (
    <div className="admin-dashboard">
      <div className="admin-header">
        <h2>Admin Dashboard</h2>
        <button onClick={onLogout} className="logout-button">Logout</button>
      </div>
      <div className="grid-container">
        <ResultForm onSubmit={onSubmit} />
        <ResultTable 
          results={results} 
          isAdmin={true} 
          onDelete={onDelete}
        />
      </div>
    </div>
  );
};

export default AdminDashboard;
