// PublicResult.js (Additional component for public view)
import React, { useState } from 'react';

const PublicResult = ({ results }) => {
  const [rollNo, setRollNo] = useState('');
  const [searchResults, setSearchResults] = useState(null);

  const handleSearch = (e) => {
    e.preventDefault();
    const found = results.filter(r => r.rollNo === rollNo);
    setSearchResults(found);
  };

  return (
    <div className="container">
      <div className="search-container">
        <h2>Check Your Result</h2>
        <form onSubmit={handleSearch} className="search-form">
          <input
            type="text"
            placeholder="Enter Roll Number"
            value={rollNo}
            onChange={(e) => setRollNo(e.target.value)}
            className="form-input"
          />
          <button type="submit" className="form-button">
            Check Result
          </button>
        </form>
      </div>

      {searchResults && searchResults.length > 0 ? (
        <div className="result-display">
          <h3>Results for Roll No: {rollNo}</h3>
          <table>
            <thead>
              <tr>
                <th>Semester</th>
                <th>Subject</th>
                <th>Marks</th>
                <th>Status</th>
              </tr>
            </thead>
            <tbody>
              {searchResults.map((result, index) => (
                <tr key={index}>
                  <td>{result.semester}</td>
                  <td>{result.subject}</td>
                  <td>{result.marks}</td>
                  <td className={result.marks >= 40 ? 'status-pass' : 'status-fail'}>
                    {result.marks >= 40 ? 'Pass' : 'Fail'}
                  </td>
                </tr>
              ))}
            </tbody>
          </table>
        </div>
      ) : searchResults && (
        <div className="no-result">
          No results found for this roll number.
        </div>
      )}
    </div>
  );
};

export default PublicResult;