import React, { useState } from 'react';
import ResultTable from './ResultTable';

const PublicSearch = ({ results }) => {
  const [searchRoll, setSearchRoll] = useState('');
  const [searchResults, setSearchResults] = useState([]);
  const [searched, setSearched] = useState(false);

  const handleSearch = (e) => {
    e.preventDefault();
    const found = results.filter(r => r.rollNo === searchRoll);
    setSearchResults(found);
    setSearched(true);
  };

  return (
    <div className="container">
      <div className="form-container">
        <h2>Check Your Result</h2>
        <form onSubmit={handleSearch}>
          <input
            type="text"
            value={searchRoll}
            onChange={(e) => setSearchRoll(e.target.value)}
            placeholder="Enter Roll Number"
            className="form-input"
            required
          />
          <button type="submit" className="form-button">Search Result</button>
        </form>
      </div>

      {searched && (
        searchResults.length > 0 ? (
          <ResultTable results={searchResults} isAdmin={false} />
        ) : (
          <div className="no-result">No results found for this roll number.</div>
        )
      )}
    </div>
  );
};

export default PublicSearch;
