// ResultDisplay.js
import React, { useState } from 'react';

const ResultDisplay = ({ results, isAdmin, onDelete }) => {
  const [searchRoll, setSearchRoll] = useState('');

  const filteredResults = results.filter(r => 
    r.rollNo.toLowerCase().includes(searchRoll.toLowerCase())
  );

  return (
    <div className="table-container">
      <input
        type="text"
        placeholder="Search by Roll Number"
        value={searchRoll}
        onChange={(e) => setSearchRoll(e.target.value)}
        className="search-input"
      />
      <table>
        <thead>
          <tr>
            <th>Roll No</th>
            <th>Name</th>
            <th>Semester</th>
            <th>Subject</th>
            <th>Marks</th>
            <th>Status</th>
            {isAdmin && <th>Actions</th>}
          </tr>
        </thead>
        <tbody>
          {filteredResults.map((result, index) => (
            <tr key={index}>
              <td>{result.rollNo}</td>
              <td>{result.name}</td>
              <td>{result.semester}</td>
              <td>{result.subject}</td>
              <td>{result.marks}</td>
              <td className={result.marks >= 40 ? 'status-pass' : 'status-fail'}>
                {result.marks >= 40 ? 'Pass' : 'Fail'}
              </td>
              {isAdmin && (
                <td>
                  <button 
                    onClick={() => onDelete(result.rollNo, result.semester)}
                    className="delete-button"
                  >
                    Delete
                  </button>
                </td>
              )}
            </tr>
          ))}
        </tbody>
      </table>
    </div>
  );
};
export default ResultDisplay;
