import React, { useState } from 'react';

const ResultForm = ({ onSubmit }) => {
  const [formData, setFormData] = useState({
    rollNo: '',
    name: '',
    semester: '1',
    marks: ''
  });

  const handleSubmit = (e) => {
    e.preventDefault();
    onSubmit(formData);
    setFormData({ rollNo: '', name: '', semester: '1', marks: '' });
  };

  return (
    <div className="form-container">
      <h3>Add New Result</h3>
      <form onSubmit={handleSubmit}>
        <input
          type="text"
          placeholder="Roll Number"
          value={formData.rollNo}
          onChange={(e) => setFormData({...formData, rollNo: e.target.value})}
          className="form-input"
          required
        />
        <input
          type="text"
          placeholder="Student Name"
          value={formData.name}
          onChange={(e) => setFormData({...formData, name: e.target.value})}
          className="form-input"
          required
        />
        <select
          value={formData.semester}
          onChange={(e) => setFormData({...formData, semester: e.target.value})}
          className="form-select"
        >
          {[1,2,3,4,5,6,7,8].map(sem => (
            <option key={sem} value={sem}>Semester {sem}</option>
          ))}
        </select>
        <input
          type="number"
          placeholder="Marks (0-100)"
          value={formData.marks}
          onChange={(e) => setFormData({...formData, marks: e.target.value})}
          className="form-input"
          min="0"
          max="100"
          required
        />
        <button type="submit" className="form-button">Add Result</button>
      </form>
    </div>
  );
};

export default ResultForm;