import React from 'react';

const ResultTable = ({ results, isAdmin, onDelete }) => {
  return (
    <div className="table-container">
      <h2>Results</h2>
      <table>
        <thead>
          <tr>
            <th>Roll No</th>
            <th>Name</th>
            <th>Semester</th>
            <th>Marks</th>
            <th>Status</th>
            {isAdmin && <th>Actions</th>}
          </tr>
        </thead>
        <tbody>
          {results.map((result, index) => (
            <tr key={index}>
              <td>{result.rollNo}</td>
              <td>{result.name}</td>
              <td>{result.semester}</td>
              <td>{result.marks}</td>
              <td className={Number(result.marks) >= 40 ? 'status-pass' : 'status-fail'}>
                {Number(result.marks) >= 40 ? 'Pass' : 'Fail'}
              </td>
              {isAdmin && (
                <td>
                  <button 
                    onClick={() => onDelete(result.rollNo)}
                    className="delete-button"
                  >
                    Delete
                  </button>
                </td>
              )}
            </tr>
          ))}
        </tbody>
      </table>
    </div>
  );
};

export default ResultTable;